/*
 * Decompiled with CFR 0.152.
 */
package xyz.blowsy.hitparticles;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import xyz.blowsy.hitparticles.Command;
import xyz.blowsy.hitparticles.HitParticlesGUI;
import xyz.blowsy.hitparticles.Utils;

@Mod(modid="hitparticles", name="Hit Particles", version="1.0", acceptedMinecraftVersions="[1.8.9]")
public class HitParticles {
    public static boolean sharpness = false;
    public static boolean critical = false;
    public static int sharpness_intensity = 1;
    public static int critical_intensity = 1;
    public static boolean cancel_imp = false;

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent e) {
        ClientCommandHandler.instance.func_71560_a((ICommand)new Command());
        FMLCommonHandler.instance().bus().register((Object)this);
        this.loadConfig();
    }

    @SubscribeEvent
    public void onAttack(AttackEntityEvent e) {
        if ((sharpness || critical) && Utils.nullCheck()) {
            Vec3 vec;
            double range;
            if (!(e.entityPlayer instanceof EntityPlayerSP) || !(e.target instanceof EntityLivingBase) || ((EntityLivingBase)e.target).field_70725_aQ != 0) {
                return;
            }
            Entity en = e.target;
            if (cancel_imp && (range = Utils.mc.field_71476_x.field_72307_f.func_72438_d(vec = Utils.mc.func_175606_aa().func_174824_e(1.0f))) > 3.0 && !Utils.mc.field_71439_g.field_71075_bZ.field_75098_d) {
                return;
            }
            if (sharpness) {
                if (sharpness_intensity == 1) {
                    this.doParticle(en, EnumParticleTypes.CRIT_MAGIC);
                } else {
                    for (int i = 0; i < sharpness_intensity; ++i) {
                        this.doParticle(en, EnumParticleTypes.CRIT_MAGIC);
                    }
                }
            }
            if (critical) {
                if (critical_intensity == 1) {
                    this.doParticle(en, EnumParticleTypes.CRIT);
                } else {
                    for (int i = 0; i < critical_intensity; ++i) {
                        this.doParticle(en, EnumParticleTypes.CRIT);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.END || !Utils.nullCheck()) {
            return;
        }
        if (Utils.mc.field_71474_y.field_74330_P) {
            return;
        }
        if (HitParticlesGUI.gui) {
            HitParticlesGUI.gui = false;
            Utils.mc.func_147108_a((GuiScreen)new HitParticlesGUI());
        }
    }

    private void doParticle(Entity en, EnumParticleTypes particleType) {
        Utils.mc.field_71452_i.func_178926_a(en, particleType);
    }

    public static void saveConfig() {
        try {
            File file = new File(Utils.mc.field_71412_D + File.separator + "HitParticles", "config");
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            FileWriter writer = new FileWriter(file, false);
            writer.write("Sharpness: " + sharpness + "\n");
            writer.write("Sharpness Intensity: " + sharpness_intensity + "\n");
            writer.write("Critical: " + critical + "\n");
            writer.write("Critical Intensity: " + critical_intensity + "\n");
            writer.write("Cancel Impossible: " + cancel_imp + "\n");
            writer.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void loadConfig() {
        try {
            String line;
            File file = new File(Utils.mc.field_71412_D + File.separator + "HitParticles", "config");
            if (!file.exists()) {
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                String arg = line.split(": ")[1];
                if (line.startsWith("Sharpness:")) {
                    sharpness = Boolean.parseBoolean(arg);
                    continue;
                }
                if (line.startsWith("Sharpness Intensity:")) {
                    sharpness_intensity = Integer.parseInt(arg);
                    continue;
                }
                if (line.startsWith("Critical:")) {
                    critical = Boolean.parseBoolean(arg);
                    continue;
                }
                if (line.startsWith("Critical Intensity:")) {
                    critical_intensity = Integer.parseInt(arg);
                    continue;
                }
                if (!line.startsWith("Cancel Impossible:")) continue;
                cancel_imp = Boolean.parseBoolean(arg);
            }
            reader.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

